import Utilities.gui_creator as gc
import Utilities.mccdaq_operations as mo

board_num, channel = 0, 0
ao_range = mo.chan_range('unipolar_5')

root = gc.create_window(title='DC Voltage Source', 
                        size='300x100')

var_ent = gc.create_control(root,
                            label='Input Voltage')

def generate_sample():  

    string_data = gc.get_control_string(var_ent)
    data_value = float(string_data)

    mo.write_sample(board_num, channel, ao_range, 
                    data_value)

    return

btn = gc.action_button(root, label='Write Sample',
                       action=generate_sample)

root.mainloop()

